/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.bindmenu;

import Krasnodar.rockstarnew.framework.base.CustomScreen;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.framework.objects.MouseButton;
import Krasnodar.rockstarnew.ui.bindmenu.BindCategory;
import Krasnodar.rockstarnew.ui.bindmenu.BindManager;
import Krasnodar.rockstarnew.ui.bindmenu.MacroBind;
import Krasnodar.rockstarnew.ui.menu.MenuScreen;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import Krasnodar.rockstarnew.utility.gui.ScrollHandler;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.interfaces.IScaledResolution;
import Krasnodar.rockstarnew.utility.render.ScissorUtility;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class BindMenuScreen
extends CustomScreen
implements IMinecraft,
IScaledResolution {
    private static final float PANEL_WIDTH = 400.0f;
    private static final float PANEL_HEIGHT = 300.0f;
    private static final float PANEL_RADIUS = 10.0f;
    private static final float PANEL_SQUIRCLE = 5.0f;
    private static final float TAB_HEIGHT = 25.0f;
    private final MenuScreen returnScreen;
    private final boolean returnToMenu;
    private final ScrollHandler scrollHandler = new ScrollHandler();
    private BindCategory selectedCategory = BindCategory.COMBAT;
    private boolean clickRequested;

    public BindMenuScreen(MenuScreen returnScreen, boolean returnToMenu) {
        this.returnScreen = returnScreen;
        this.returnToMenu = returnToMenu;
    }

    @Override
    public void render(UIContext context) {
        float panelX = sr.getScaledWidth() / 2.0f - 200.0f;
        float panelY = sr.getScaledHeight() / 2.0f - 150.0f;
        this.drawPanelBackground(context, panelX, panelY, 400.0f, 300.0f);
        this.renderTabs(context, panelX, panelY);
        this.renderBindsList(context, panelX + 10.0f, panelY + 25.0f + 15.0f, 380.0f, 250.0f);
        this.clickRequested = false;
    }

    private void renderTabs(UIContext context, float panelX, float panelY) {
        Font font = Fonts.REGULAR.getFont(8.0f);
        float x = panelX + 10.0f;
        float y = panelY + 8.0f;
        for (BindCategory category : BindCategory.values()) {
            x = this.renderTab(context, font, x, y, category.getDisplayName(), this.selectedCategory == category, () -> this.selectCategory(category));
        }
    }

    private float renderTab(UIContext context, Font font, float x, float y, String label, boolean selected, Runnable onClick) {
        float width = font.width(label) + 16.0f;
        boolean hovered = GuiUtility.isHovered((double)x, (double)y, (double)width, 25.0, context.getMouseX(), context.getMouseY());
        float alpha = selected ? 1.0f : (hovered ? 0.8f : 0.4f);
        context.drawRoundedRect(x, y, width, 25.0f, BorderRadius.all(4.0f), Colors.getAdditionalColor().mulAlpha(alpha));
        context.drawText(font, label, x + 8.0f, y + 8.0f, Colors.getTextColor().mulAlpha(selected ? 1.0f : 0.75f));
        if (hovered && this.clickRequested) {
            onClick.run();
        }
        return x + width + 8.0f;
    }

    private void renderBindsList(UIContext context, float x, float y, float width, float height) {
        List<MacroBind> categoryBinds = this.getBindsForCategory(this.selectedCategory);
        float itemHeight = 30.0f;
        float contentHeight = (float)categoryBinds.size() * (itemHeight + 5.0f);
        this.scrollHandler.setMax(-Math.max(0.0f, contentHeight - height));
        this.scrollHandler.update();
        float scrollOffset = (float)this.scrollHandler.getValue();
        ScissorUtility.push(context.method_51448(), x, y, width, height);
        Font font = Fonts.REGULAR.getFont(7.0f);
        float currentY = y - scrollOffset;
        for (MacroBind bind : categoryBinds) {
            if (currentY + itemHeight > y && currentY < y + height) {
                this.renderBindItem(context, font, x, currentY, width, itemHeight, bind);
            }
            currentY += itemHeight + 5.0f;
        }
        ScissorUtility.pop();
    }

    private void renderBindItem(UIContext context, Font font, float x, float y, float width, float height, MacroBind bind) {
        boolean hovered = GuiUtility.isHovered((double)x, (double)y, (double)width, (double)height, context.getMouseX(), context.getMouseY());
        context.drawRoundedRect(x, y, width, height, BorderRadius.all(5.0f), Colors.getAdditionalColor().mulAlpha(hovered ? 0.4f : 0.2f));
        context.drawText(font, bind.getName(), x + 10.0f, y + 8.0f, Colors.getTextColor());
        String keyText = bind.getKeyName();
        if (keyText == null || keyText.isEmpty()) {
            keyText = "\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043e";
        }
        float keyWidth = font.width(keyText) + 16.0f;
        float keyX = x + width - keyWidth - 10.0f;
        context.drawRoundedRect(keyX, y + 5.0f, keyWidth, height - 10.0f, BorderRadius.all(3.0f), Colors.getBackgroundColor().mulAlpha(0.8f));
        context.drawText(font, keyText, keyX + 8.0f, y + 11.0f, Colors.getTextColor().mulAlpha(0.8f));
        if (!hovered || this.clickRequested) {
            // empty if block
        }
    }

    private List<MacroBind> getBindsForCategory(BindCategory category) {
        return BindManager.getInstance().getBindsForCategory(category);
    }

    private void selectCategory(BindCategory category) {
        if (category != this.selectedCategory) {
            this.selectedCategory = category;
            this.scrollHandler.reset();
        }
    }

    private void drawPanelBackground(UIContext context, float x, float y, float width, float height) {
        context.drawBlurredRect(x, y, width, height, 45.0f, 5.0f, BorderRadius.all(10.0f), ColorRGBA.WHITE);
        context.drawSquircle(x, y, width, height, 5.0f, BorderRadius.all(10.0f), Colors.getBackgroundColor().withAlpha(229.5f));
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        if (button == MouseButton.LEFT) {
            this.clickRequested = true;
        }
        super.onMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        float listH;
        float listW;
        float listY;
        float listX = sr.getScaledWidth() / 2.0f - 200.0f + 10.0f;
        if (GuiUtility.isHovered((double)listX, (double)(listY = sr.getScaledHeight() / 2.0f - 150.0f + 25.0f + 15.0f), (double)(listW = 380.0f), (double)(listH = 250.0f), mouseX, mouseY)) {
            this.scrollHandler.scroll(verticalAmount);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25419() {
        super.method_25419();
        if (this.returnToMenu && this.returnScreen != null) {
            mc.method_1507((class_437)this.returnScreen);
        }
    }
}

